#include<cstdio>
#include<cctype>
#include<cstring>
const int MOD = 1000000007;
const int ERROR = -1, UNUSED = 0, IN = 1, USED = 2;

void parse(const char *s, int& r, int& c)
{
	r = 0;
	for (int i = 1; s[i] && s[i] != '+'; ++i)
	{
		r = r * 10 + (s[i] - '0');
	}
	--r;
	c = s[0] - 'A';
	return;
}

int dfs(char ***table, int **result, int **label, int r, int c)
{
	int ret;
	
	if (label[r][c] == IN)
	{
		result[r][c] = ERROR;
		label[r][c] = USED;
		return ERROR;
	}
	if (label[r][c] == USED)
	{
		return result[r][c];
	}
	
	label[r][c] = IN;
	
	if (table[r][c][0] != '=')
	{
		ret = result[r][c] = table[r][c][0] - '0';
	}
	else
	{
		int idx = 0;
		int r0, c0, r1, c1;
		int res0, res1;
		
		while (table[r][c][idx] != '+')
		{
			++idx;
		}
		
		if (isalpha(table[r][c][1]))
		{
			parse(table[r][c] + 1, r0, c0);
			res0 = dfs(table, result, label, r0, c0);
		}
		else
		{
			res0 = table[r][c][1] - '0';
		}
		
		if (isalpha(table[r][c][idx + 1]))
		{
			parse(table[r][c] + idx + 1, r1, c1);
			res1 = dfs(table, result, label, r1, c1);
		}
		else
		{
			res1 = table[r][c][idx + 1] - '0';
		}
		
		if (res0 == ERROR || res1 == ERROR)
		{
			ret = result[r][c] = ERROR;
		}
		else
		{
			ret = result[r][c] = (res0 + res1) % MOD;
		}
	}
	
	label[r][c] = USED;
	
	return ret;
}

void solve(char ***table, int **result, int m, int n)
{
	int **label = new int* [m];
	for (int i = 0; i < m; ++i)
	{
		label[i] = new int [n];
		memset(label[i], 0, sizeof(int) * n);
	}
	for (int i = 0; i < m; ++i)
	{
		for (int j = 0; j < n; ++j)
		{
			if (label[i][j] != USED)
			{
				dfs(table, result, label, i, j);
			}
		}
	}
	
	for (int i = 0; i < m; ++i)
	{
		delete [] label[i];
	}
	delete [] label;
	
	return;
}

void print(int **result, int m, int n)
{
	for (int i = 0; i < m; ++i)
	{
		for (int j = 0; j < n; ++j)
		{
			if (result[i][j] == ERROR)
			{
				printf("ERROR");
			}
			else
			{
				printf("%d", result[i][j]);
			}
			printf("%c", j == n - 1 ? '\n' : ' ');
		}
	}
	return;
}

int main()
{
	int m, n;
	char ***table = nullptr;
	int **result = nullptr;
	
	scanf("%d%d", &m, &n);
	table = new char** [m];
	result = new int* [m];
	for (int i = 0; i < m; ++i)
	{
		table[i] = new char* [n];
		result[i] = new int [n];
		for (int j = 0; j < n; ++j)
		{
			table[i][j] = new char [10];
			scanf("%s", table[i][j]);
		}
	}
	
	solve(table, result, m, n);
	print(result, m, n);
	
	for (int i = 0; i < m; ++i)
	{
		for (int j = 0; j < n; ++j)
		{
			delete [] table[i][j];
		}
		delete [] table[i];
		delete [] result[i];
	}
	delete [] table;
	delete [] result;
	return 0;
}
